using System;
using System.Collections.Generic;

namespace ConsoleApp1
{
    internal class Program
    {
        public struct Tacka
        {
            public long x, y;
            public Tacka(long x, long y) { this.x = x; this.y = y; }
        }
        public static long Pertlanje(Tacka a, Tacka b, Tacka c)
        {
            return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
        }
        public static long Povrsina(List<Tacka> tacke)
        {
            int n = tacke.Count;
            long p = 0;
            for (int i = 0; i < n; i++)
            {
                int j = (i + 1) % n;
                p += tacke[i].x * tacke[j].y - tacke[j].x * tacke[i].y;
            }
            return Math.Abs(p) / 2;
        }

        public static List<Tacka> KonveksOm(List<Tacka> tacke)
        {
            int n = tacke.Count;
            for (int i = 0; i < n - 1; i++)
            {
                for (int j = 0; j < n - i - 1; j++)
                {
                    if (tacke[j].x > tacke[j + 1].x || (tacke[j].x == tacke[j + 1].x && tacke[j].y > tacke[j + 1].y))
                    {
                        Tacka x = tacke[j];
                        tacke[j] = tacke[j + 1];
                        tacke[j + 1] = x;
                    }
                }
            }
            List<Tacka> donja = new List<Tacka>();
            for (int i = 0; i < tacke.Count; i++)
            {
                Tacka p = tacke[i];
                while (donja.Count >= 2 && Pertlanje(donja[donja.Count - 2], donja[donja.Count - 1], p) <= 0)
                {
                    donja.RemoveAt(donja.Count - 1);
                }
                donja.Add(p);
            }
            List<Tacka> gornja = new List<Tacka>();
            for (int i = tacke.Count - 1; i >= 0; i--)
            {
                Tacka p = tacke[i];
                while (gornja.Count >= 2 && Pertlanje(gornja[gornja.Count - 2], gornja[gornja.Count - 1], p) <= 0)
                {
                    gornja.RemoveAt(gornja.Count - 1);
                }
                gornja.Add(p);
            }
            donja.RemoveAt(donja.Count - 1);
            gornja.RemoveAt(gornja.Count - 1);
            donja.AddRange(gornja);
            return donja;
        }
        public static long PovrsinaOmotaca(List<Tacka> tacke)
        {
            List<Tacka> omotac = KonveksOm(tacke);
            return Povrsina(omotac);
        }

        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            List<Tacka> tacke = new List<Tacka>();

            for (int i = 0; i < n; i++)
            {
                var koordinate = Console.ReadLine().Split(" ");
                Tacka t = new Tacka(long.Parse(koordinate[0]), long.Parse(koordinate[1]));
                tacke.Add(t);
            }
            long najmanja = long.MaxValue;

            for (int i = 0; i < n; i++)
            {
                List<Tacka> podskupTacaka = new List<Tacka>();
                for (int j = 0; j < n; j++)
                {
                    if (j != i)
                    {
                        podskupTacaka.Add(tacke[j]);
                    }
                }
                long povrsina = PovrsinaOmotaca(podskupTacaka);
                najmanja = Math.Min(najmanja, povrsina);
            }
            Console.WriteLine(najmanja);
        }


    }

}